dnl ##
dnl ##  OSSP cfg - Configuration Parsing
dnl ##  Copyright (c) 2002-2003 Ralf S. Engelschall <rse@engelschall.com>
dnl ##  Copyright (c) 2002-2003 The OSSP Project <http://www.ossp.org/>
dnl ##  Copyright (c) 2002-2003 Cable & Wireless Deutschland <http://www.cw.com/de/>
dnl ##
dnl ##  This file is part of OSSP cfg, a configuration parsing library which
dnl ##  can be found at http://www.ossp.org/pkg/lib/cfg/.
dnl ##
dnl ##  Permission to use, copy, modify, and distribute this software for
dnl ##  any purpose with or without fee is hereby granted, provided that
dnl ##  the above copyright notice and this permission notice appear in all
dnl ##  copies.
dnl ##
dnl ##  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
dnl ##  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
dnl ##  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
dnl ##  IN NO EVENT SHALL THE AUTHORS AND COPYRIGHT HOLDERS AND THEIR
dnl ##  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
dnl ##  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
dnl ##  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
dnl ##  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
dnl ##  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
dnl ##  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
dnl ##  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
dnl ##  SUCH DAMAGE.
dnl ##
dnl ##  aclocal.m4: GNU Autoconf local macro definitions
dnl ##

dnl ##
dnl ##  Check whether compiler option works
dnl ##
dnl ##  configure.in:
dnl ##    AC_COMPILER_OPTION(<name>, <display>, <option>,
dnl ##                       <action-success>, <action-failure>)
dnl ##

AC_DEFUN(AC_COMPILER_OPTION,[dnl
AC_MSG_CHECKING(whether compiler option(s) $2 work)
AC_CACHE_VAL(ac_cv_compiler_option_$1,[
SAVE_CFLAGS="$CFLAGS"
CFLAGS="$CFLAGS $3"
AC_TRY_COMPILE([],[], ac_cv_compiler_option_$1=yes, ac_cv_compiler_option_$1=no)
CFLAGS="$SAVE_CFLAGS"
])dnl
if test ".$ac_cv_compiler_option_$1" = .yes; then
    ifelse([$4], , :, [$4])
else
    ifelse([$5], , :, [$5])
fi
AC_MSG_RESULT([$ac_cv_compiler_option_$1])
])dnl

dnl ##
dnl ##  Debugging Support
dnl ##
dnl ##  configure.in:
dnl ##    AC_CHECK_DEBUGGING
dnl ##

AC_DEFUN(AC_CHECK_DEBUGGING,[dnl
AC_ARG_ENABLE(debug,dnl
[  --enable-debug          build for debugging (default=no)],
[dnl
if test ".$ac_cv_prog_gcc" = ".yes"; then
    case "$CFLAGS" in
        *-O* ) ;;
           * ) CFLAGS="$CFLAGS -O2" ;;
    esac
    case "$CFLAGS" in
        *-g* ) ;;
           * ) CFLAGS="$CFLAGS -g" ;;
    esac
    case "$CFLAGS" in
        *-pipe* ) ;;
              * ) AC_COMPILER_OPTION(pipe, -pipe, -pipe, CFLAGS="$CFLAGS -pipe") ;;
    esac
    AC_COMPILER_OPTION(defdbg, -DDEBUG, -DDEBUG, CFLAGS="$CFLAGS -DDEBUG")
    CFLAGS="$CFLAGS -pedantic"
    CFLAGS="$CFLAGS -Wall"
    WMORE=""
    WMORE="$WMORE -Wbad-function-cast"
    WMORE="$WMORE -Wcast-align"
    WMORE="$WMORE -Winline"
    WMORE="$WMORE -Wmissing-declarations"
    WMORE="$WMORE -Wmissing-prototypes"
    WMORE="$WMORE -Wmultichar"
    WMORE="$WMORE -Wnested-externs"
    WMORE="$WMORE -Wno-system-headers"
    WMORE="$WMORE -Wpointer-arith"
    WMORE="$WMORE -Wredundant-decls"
    WMORE="$WMORE -Wshadow"
    WMORE="$WMORE -Wstrict-prototypes"
    AC_COMPILER_OPTION(wmore, -W<xxx>, $WMORE, CFLAGS="$CFLAGS $WMORE")
else
    case "$CFLAGS" in
        *-g* ) ;;
           * ) CFLAGS="$CFLAGS -g" ;;
    esac
fi
msg="enabled"
],[
if test ".$ac_cv_prog_gcc" = ".yes"; then
case "$CFLAGS" in
    *-pipe* ) ;;
          * ) AC_COMPILER_OPTION(pipe, -pipe, -pipe, CFLAGS="$CFLAGS -pipe") ;;
esac
fi
case "$CFLAGS" in
    *-g* ) CFLAGS=`echo "$CFLAGS" |\
                   sed -e 's/ -g / /g' -e 's/ -g$//' -e 's/^-g //g' -e 's/^-g$//'` ;;
esac
case "$CXXFLAGS" in
    *-g* ) CXXFLAGS=`echo "$CXXFLAGS" |\
                     sed -e 's/ -g / /g' -e 's/ -g$//' -e 's/^-g //g' -e 's/^-g$//'` ;;
esac
msg=disabled
])dnl
AC_MSG_CHECKING(for compilation debug mode)
AC_MSG_RESULT([$msg])
if test ".$msg" = .enabled; then
    enable_shared=no
fi
])

dnl ##
dnl ##  Check for an external/extension library.
dnl ##  - is aware of <libname>-config style scripts
dnl ##  - searches under standard paths include, lib, etc.
dnl ##  - searches under subareas like .libs, etc.
dnl ##
dnl ##  configure.in:
dnl ##      AC_CHECK_EXTLIB(<realname>, <libname>, <func>, <header>,
dnl ##                      [<success-action> [, <fail-action>]])
dnl ##  Makefile.in:
dnl ##      CFLAGS  = @CFLAGS@
dnl ##      LDFLAGS = @LDFLAGS@
dnl ##      LIBS    = @LIBS@
dnl ##  shell:
dnl ##      $ ./configure --with-<libname>[=DIR]
dnl ##

AC_DEFUN(AC_CHECK_EXTLIB,[dnl
AC_ARG_WITH($2, [dnl
[  --with-]m4_substr([$2[[=DIR]]                     ], 0, 19)[build with external $1 library (default=no)]], [dnl
    if test ".$with_$2" = .yes; then
        #   via config script in PATH
        $2_version=`($2-config --version) 2>/dev/null`
        if test ".$$2_version" != .; then
            CPPFLAGS="$CPPFLAGS `$2-config --cflags`"
            CFLAGS="$CFLAGS `$2-config --cflags`"
            LDFLAGS="$LDFLAGS `$2-config --ldflags`"
        fi
    else
        if test -d "$with_$2"; then
            found=0
            #   via config script
            for dir in $with_$2/bin $with_$2; do
                if test -f "$dir/$2-config" && test ! -f "$dir/$2-config.in"; then
                    $2_version=`($dir/$2-config --version) 2>/dev/null`
                    if test ".$$2_version" != .; then
                        CPPFLAGS="$CPPFLAGS `$dir/$2-config --cflags`"
                        CFLAGS="$CFLAGS `$dir/$2-config --cflags`"
                        LDFLAGS="$LDFLAGS `$dir/$2-config --ldflags`"
                        found=1
                        break
                    fi
                fi
            done
            #   in standard sub-areas
            if test ".$found" = .0; then
                for dir in $with_$2/include/$2 $with_$2/include $with_$2; do
                    if test -f "$dir/$4"; then
                        CPPFLAGS="$CPPFLAGS -I$dir"
                        CFLAGS="$CFLAGS -I$dir"
                        found=1
                        break
                    fi
                done
                for dir in $with_$2/lib/$2 $with_$2/lib $with_$2; do
                    if test -f "$dir/lib$2.la" && test -d "$dir/.libs"; then
                        LDFLAGS="$LDFLAGS -L$dir -L$dir/.libs"
                        found=1
                        break
                    elif test -f "$dir/lib$2.a" || test -f "$dir/lib$2.so"; then
                        LDFLAGS="$LDFLAGS -L$dir"
                        found=1
                        break
                    fi
                done
            fi
            #   in any sub-area
            if test ".$found" = .0; then
changequote(, )dnl
                for file in x `find $with_$2 -name "$4" -type f -print`; do
                    test .$file = .x && continue
                    dir=`echo $file | sed -e 's;[^/]*$;;' -e 's;\(.\)/$;\1;'`
                    CPPFLAGS="$CPPFLAGS -I$dir"
                    CFLAGS="$CFLAGS -I$dir"
                done
                for file in x `find $with_$2 -name "lib$2.[aso]" -type f -print`; do
                    test .$file = .x && continue
                    dir=`echo $file | sed -e 's;[^/]*$;;' -e 's;\(.\)/$;\1;'`
                    LDFLAGS="$LDFLAGS -L$dir"
                done
changequote([, ])dnl
            fi
        fi
    fi
    AC_HAVE_HEADERS($4)
    AC_CHECK_LIB($2, $3)
    with_$2=yes
    ac_var="ac_cv_header_`echo $4 | sed 'y%./+-%__p_%'`"
    eval "ac_val=\$$ac_var"
    if test ".$ac_val" != .yes; then
        with_$2=no
    fi
    if test ".$ac_cv_lib_$2_$3" != .yes; then
        with_$2=no
    fi
    if test ".$with_$2" = .no; then
        AC_ERROR([Unable to find $1 library])
    fi
    ], [dnl
if test ".$with_$2" = .; then
    with_$2=no
fi
    ])dnl
AC_MSG_CHECKING(whether to build against external $1 library)
if test ".$with_$2" = .yes; then
    ifelse([$5], , :, [$5])
else
    ifelse([$6], , :, [$6])
fi
AC_MSG_RESULT([$with_$2])
])dnl

dnl ##
dnl ##  Check for GNU Bison and GNU Flex
dnl ##
dnl ##  configure.in:
dnl ##      AC_CHECK_BISON(BISON, 1.30, [1.3[0-9]|1.[4-9]])
dnl ##      AC_CHECK_FLEX(FLEX, 2.5.6, [2.5.[6-9]|2.5.1[0-9]|2.[6-9].*])
dnl ##
dnl ##  Makefile.in:
dnl ##      BISON = @BISON@
dnl ##      FLEX  = @FLEX@
dnl ##

AC_DEFUN(AC_CHECK_BISON,[dnl
if test ".$enable_maintainer" = .yes; then
    bison_version=""
    for prog in bison bison-beta bison-alpha bison-snap; do
        AC_PATH_PROG($1, $prog, NA)
        if test ".$$1" != .NA; then
            bison_version=`($$1 --version | head -1 | sed -e 's;^[[^0-9]]*\([[0-9]][[0-9.]]*\).*;\1;') 2>/dev/null`
            case "$bison_version" in
                $3 ) break ;;
                * ) $1="NA"; unset ac_cv_path_$1 ;;
            esac
        else
            unset ac_cv_path_$1
        fi
    done
    if test ".$$1" = .NA; then
        if test ".$bison_version" != .; then
            AC_ERROR([found GNU Bison version $bison_version; require version >= $2])
        else
            AC_ERROR([require GNU Bison version >= $2])
        fi
    fi
else
    dnl # disable the use of the tools, but still allow manual override
    test ".$$1" = . && $1=true
    AC_PATH_PROG($1, bison, true)
fi
])

AC_DEFUN(AC_CHECK_FLEX,[dnl
if test ".$enable_maintainer" = .yes; then
    flex_version=""
    for prog in flex flex-beta flex-alpha flex-snap; do
        AC_PATH_PROG($1, $prog, NA)
        if test ".$$1" != .NA; then
            flex_version=`($$1 --version | head -1 | sed -e 's;^[[^0-9]]*\([[0-9]][[0-9.]]*\).*;\1;') 2>/dev/null`
            case "$flex_version" in
                $3 ) break ;;
                * ) $1="NA"; unset ac_cv_path_$1 ;;
            esac
        else
            unset ac_cv_path_$1
        fi
    done
    if test ".$$1" = .NA; then
        if test ".$flex_version" != .; then
            AC_ERROR([found GNU Flex version $flex_version; require version >= $2])
        else
            AC_ERROR([require GNU Flex version >= $2])
        fi
    fi
else
    test ".$$1" = . && $1=true
    AC_PATH_PROG($1, flex, true)
fi
])

