/*
 * This file was generated automatically by xsubpp version 1.9508 from the
 * contents of cfg.xs. Do not edit this file, edit cfg.xs instead.
 *
 *	ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "cfg.xs"
/*
**  OSSP cfg - Configuration Parsing
**  Copyright (c) 2002-2005 Ralf S. Engelschall <rse@engelschall.com>
**  Copyright (c) 2002-2005 The OSSP Project <http://www.ossp.org/>
**  Copyright (c) 2002-2005 Cable & Wireless <http://www.cw.com/>
**
**  This file is part of OSSP cfg, a configuration parsing library which
**  can be found at http://www.ossp.org/pkg/lib/cfg/.
**
**  Permission to use, copy, modify, and distribute this software for
**  any purpose with or without fee is hereby granted, provided that
**  the above copyright notice and this permission notice appear in all
**  copies.
**
**  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
**  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
**  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
**  IN NO EVENT SHALL THE AUTHORS AND COPYRIGHT HOLDERS AND THEIR
**  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
**  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
**  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
**  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
**  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
**  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
**  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
**  SUCH DAMAGE.
**
**  cfg.xs: Perl Binding (Perl/XS part)
*/

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "cfg.h"

/* find/apply callback context */
typedef struct {
    SV *fct;
    SV *ctx;
} cb_ctx_t;

/* find/apply callback wrapper */
static cfg_rc_t cb_fct(cfg_t *cfg, cfg_node_t *node, void *_ctx)
{
    cb_ctx_t *ctx = (cb_ctx_t *)ctx;
    cfg_rc_t rc;
    dSP;

    ENTER; SAVETMPS;
    PUSHMARK(SP); 
    XPUSHs(sv_2mortal(newSViv(PTR2IV(cfg))));
    XPUSHs(sv_2mortal(newSViv(PTR2IV(node))));
    XPUSHs(ctx->ctx);
    PUTBACK;
    if (call_sv(ctx->fct, G_SCALAR) != 1)
        croak("cfg_node_find: expected single scalar as return value from callback");
    SPAGAIN;
    rc = (cfg_rc_t)SvIV(POPs);
    FREETMPS; LEAVE;
    return rc;
}

#line 74 "cfg.c"
XS(XS_OSSP__cfg_constant); /* prototype to pass -Wmissing-prototypes */
XS(XS_OSSP__cfg_constant)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OSSP::cfg::constant(sv)");
    SP -= items;
    {
#line 69 "cfg.xs"
        dXSTARG;
        STRLEN          len;
        int             i;
        static struct {
            const char *name;
            int         value;
        } constant_table[] = {
            { "CFG_OK",                CFG_OK                },
            { "CFG_ERR_ARG",           CFG_ERR_ARG           },
            { "CFG_ERR_USE",           CFG_ERR_USE           },
            { "CFG_ERR_MEM",           CFG_ERR_MEM           },
            { "CFG_ERR_SYS",           CFG_ERR_SYS           },
            { "CFG_ERR_FMT",           CFG_ERR_FMT           },
            { "CFG_ERR_INT",           CFG_ERR_INT           },
            { "CFG_ERR_SYN",           CFG_ERR_SYN           },
            { "CFG_ERR_NDE",           CFG_ERR_NDE           },
            { "CFG_FMT_CFG",           CFG_FMT_CFG           },
            { "CFG_FMT_XML",           CFG_FMT_XML           },
            { "CFG_NODE_TYPE_SEQ",     CFG_NODE_TYPE_SEQ     },
            { "CFG_NODE_TYPE_DIR",     CFG_NODE_TYPE_DIR     },
            { "CFG_NODE_TYPE_OPT",     CFG_NODE_TYPE_OPT     },
            { "CFG_NODE_TYPE_ARG",     CFG_NODE_TYPE_ARG     },
            { "CFG_NODE_ATTR_PARENT",  CFG_NODE_ATTR_PARENT  },
            { "CFG_NODE_ATTR_LBROTH",  CFG_NODE_ATTR_LBROTH  },
            { "CFG_NODE_ATTR_RBROTH",  CFG_NODE_ATTR_RBROTH  },
            { "CFG_NODE_ATTR_CHILD1",  CFG_NODE_ATTR_CHILD1  },
            { "CFG_NODE_ATTR_CHILDL",  CFG_NODE_ATTR_CHILDL  },
            { "CFG_NODE_ATTR_CHILDS",  CFG_NODE_ATTR_CHILDS  },
            { "CFG_NODE_ATTR_NODES",   CFG_NODE_ATTR_NODES   },
            { "CFG_NODE_ATTR_DEPTH",   CFG_NODE_ATTR_DEPTH   },
            { "CFG_NODE_ATTR_SRCNAME", CFG_NODE_ATTR_SRCNAME },
            { "CFG_NODE_ATTR_SRCPOS",  CFG_NODE_ATTR_SRCPOS  },
            { "CFG_NODE_ATTR_TYPE",    CFG_NODE_ATTR_TYPE    },
            { "CFG_NODE_ATTR_TOKEN",   CFG_NODE_ATTR_TOKEN   },
            { "CFG_NODE_ATTR_DATA",    CFG_NODE_ATTR_DATA    },
            { "CFG_DATA_TYPE_PTR",     CFG_DATA_TYPE_PTR     },
            { "CFG_DATA_TYPE_STR",     CFG_DATA_TYPE_STR     },
            { "CFG_DATA_TYPE_INT",     CFG_DATA_TYPE_INT     },
            { "CFG_DATA_TYPE_FLT",     CFG_DATA_TYPE_FLT     },
            { "CFG_DATA_CTRL_CLONE",   CFG_DATA_CTRL_CLONE   },
            { "CFG_DATA_CTRL_DESTROY", CFG_DATA_CTRL_DESTROY },
            { "CFG_DATA_ATTR_TYPE",    CFG_DATA_ATTR_TYPE    },
            { "CFG_DATA_ATTR_VALUE",   CFG_DATA_ATTR_VALUE   },
            { "CFG_DATA_ATTR_CTRL",    CFG_DATA_ATTR_CTRL    }
        };
#line 129 "cfg.c"
	SV *	sv = ST(0);
	const char *	s = SvPV(sv, len);
#line 118 "cfg.xs"
        for (i = 0; i < sizeof(constant_table)/sizeof(constant_table[0]); i++) {
            if (strcmp(s, constant_table[i].name) == 0) {
                EXTEND(SP, 1);
                PUSHs(&PL_sv_undef);
                PUSHi(constant_table[i].value);
                break;
            }
        }
        if (i == sizeof(constant_table)/sizeof(constant_table[0])) {
            sv = sv_2mortal(newSVpvf("unknown contant OSSP::cfg::%s", s));
            PUSHs(sv);
        }
#line 145 "cfg.c"
	PUTBACK;
	return;
    }
}

XS(XS_OSSP__cfg_cfg_create); /* prototype to pass -Wmissing-prototypes */
XS(XS_OSSP__cfg_cfg_create)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OSSP::cfg::cfg_create(cfg)");
    {
	cfg_t *	cfg;
	cfg_rc_t	RETVAL;
	dXSTARG;
#line 138 "cfg.xs"
        RETVAL = cfg_create(&cfg);
#line 163 "cfg.c"
	sv_setref_pv(ST(0), Nullch, (void*)cfg);
	SvSETMAGIC(ST(0));
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_OSSP__cfg_cfg_destroy); /* prototype to pass -Wmissing-prototypes */
XS(XS_OSSP__cfg_cfg_destroy)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: OSSP::cfg::cfg_destroy(cfg)");
    {
	cfg_t *	cfg;
	cfg_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    cfg = INT2PTR(cfg_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "cfg is not a reference");
#line 150 "cfg.xs"
        RETVAL = cfg_destroy(cfg);
#line 190 "cfg.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_OSSP__cfg_cfg_error); /* prototype to pass -Wmissing-prototypes */
XS(XS_OSSP__cfg_cfg_error)
{
    dXSARGS;
    if (items != 3)
	Perl_croak(aTHX_ "Usage: OSSP::cfg::cfg_error(cfg, rc, error)");
    {
	cfg_t *	cfg;
	cfg_rc_t	rc = (cfg_rc_t)SvIV(ST(1));
	char *	error;
	cfg_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    cfg = INT2PTR(cfg_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "cfg is not a reference");
#line 163 "cfg.xs"
        RETVAL = cfg_error(cfg, rc, &error);
#line 217 "cfg.c"
	sv_setpv((SV*)ST(2), error);
	SvSETMAGIC(ST(2));
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_OSSP__cfg_cfg_version); /* prototype to pass -Wmissing-prototypes */
XS(XS_OSSP__cfg_cfg_version)
{
    dXSARGS;
    if (items != 0)
	Perl_croak(aTHX_ "Usage: OSSP::cfg::cfg_version()");
    {
	long	RETVAL;
	dXSTARG;
#line 173 "cfg.xs"
        RETVAL = cfg_version();
#line 236 "cfg.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_OSSP__cfg_cfg_import); /* prototype to pass -Wmissing-prototypes */
XS(XS_OSSP__cfg_cfg_import)
{
    dXSARGS;
    if (items != 5)
	Perl_croak(aTHX_ "Usage: OSSP::cfg::cfg_import(cfg, node, fmt, in_ptr, in_len)");
    {
	cfg_t *	cfg;
	cfg_node_t *	node;
	cfg_fmt_t	fmt = (cfg_fmt_t)SvIV(ST(2));
	const char *	in_ptr = (const char *)SvPV_nolen(ST(3));
	size_t	in_len = (size_t)SvUV(ST(4));
	cfg_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    cfg = INT2PTR(cfg_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "cfg is not a reference");

	if (SvROK(ST(1))) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    node = INT2PTR(cfg_node_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "node is not a reference");
#line 188 "cfg.xs"
        if (ST(4) == &PL_sv_undef)
            in_len = sv_len(ST(3));
        RETVAL = cfg_import(cfg, node, fmt, in_ptr, in_len);
#line 274 "cfg.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_OSSP__cfg_cfg_export); /* prototype to pass -Wmissing-prototypes */
XS(XS_OSSP__cfg_cfg_export)
{
    dXSARGS;
    if (items != 5)
	Perl_croak(aTHX_ "Usage: OSSP::cfg::cfg_export(cfg, node, fmt, ex_ptr, ex_len)");
    {
	cfg_t *	cfg;
	cfg_node_t *	node;
	cfg_fmt_t	fmt = (cfg_fmt_t)SvIV(ST(2));
	char *	ex_ptr;
	size_t	ex_len = (size_t)SvUV(ST(4));
	cfg_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    cfg = INT2PTR(cfg_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "cfg is not a reference");

	if (SvROK(ST(1))) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    node = INT2PTR(cfg_node_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "node is not a reference");
#line 205 "cfg.xs"
        RETVAL = cfg_export(cfg, node, fmt, &ex_ptr, ex_len);
#line 310 "cfg.c"
	sv_setpv((SV*)ST(3), ex_ptr);
	SvSETMAGIC(ST(3));
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_OSSP__cfg_cfg_node_create); /* prototype to pass -Wmissing-prototypes */
XS(XS_OSSP__cfg_cfg_node_create)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: OSSP::cfg::cfg_node_create(cfg, node)");
    {
	cfg_t *	cfg;
	cfg_node_t *	node;
	cfg_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    cfg = INT2PTR(cfg_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "cfg is not a reference");
#line 218 "cfg.xs"
        RETVAL = cfg_node_create(cfg, &node);
#line 338 "cfg.c"
	sv_setref_pv(ST(1), Nullch, (void*)node);
	SvSETMAGIC(ST(1));
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_OSSP__cfg_cfg_node_destroy); /* prototype to pass -Wmissing-prototypes */
XS(XS_OSSP__cfg_cfg_node_destroy)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: OSSP::cfg::cfg_node_destroy(cfg, node)");
    {
	cfg_t *	cfg;
	cfg_node_t *	node;
	cfg_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    cfg = INT2PTR(cfg_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "cfg is not a reference");

	if (SvROK(ST(1))) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    node = INT2PTR(cfg_node_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "node is not a reference");
#line 231 "cfg.xs"
        RETVAL = cfg_node_destroy(cfg, node);
#line 373 "cfg.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_OSSP__cfg_cfg_node_clone); /* prototype to pass -Wmissing-prototypes */
XS(XS_OSSP__cfg_cfg_node_clone)
{
    dXSARGS;
    if (items != 3)
	Perl_croak(aTHX_ "Usage: OSSP::cfg::cfg_node_clone(cfg, node, node2)");
    {
	cfg_t *	cfg;
	cfg_node_t *	node;
	cfg_node_t *	node2;
	cfg_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    cfg = INT2PTR(cfg_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "cfg is not a reference");

	if (SvROK(ST(1))) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    node = INT2PTR(cfg_node_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "node is not a reference");
#line 244 "cfg.xs"
        RETVAL = cfg_node_clone(cfg, node, &node2);
#line 407 "cfg.c"
	sv_setref_pv(ST(2), Nullch, (void*)node2);
	SvSETMAGIC(ST(2));
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_OSSP__cfg_cfg_node_set); /* prototype to pass -Wmissing-prototypes */
XS(XS_OSSP__cfg_cfg_node_set)
{
    dXSARGS;
    if (items != 4)
	Perl_croak(aTHX_ "Usage: OSSP::cfg::cfg_node_set(cfg, node, attr, va_arg1)");
    if ((   (cfg_node_attr_t)SvIV(ST(2)) == CFG_NODE_ATTR_PARENT \
           || (cfg_node_attr_t)SvIV(ST(2)) == CFG_NODE_ATTR_LBROTH \
           || (cfg_node_attr_t)SvIV(ST(2)) == CFG_NODE_ATTR_RBROTH \
           || (cfg_node_attr_t)SvIV(ST(2)) == CFG_NODE_ATTR_CHILD1 \
           || (cfg_node_attr_t)SvIV(ST(2)) == CFG_NODE_ATTR_CHILDL  ))
    {
	cfg_t *	cfg;
	cfg_node_t *	node;
	cfg_node_attr_t	attr = (cfg_node_attr_t)SvIV(ST(2));
	cfg_node_t *	va_arg1;
	cfg_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    cfg = INT2PTR(cfg_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "cfg is not a reference");

	if (SvROK(ST(1))) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    node = INT2PTR(cfg_node_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "node is not a reference");

	if (SvROK(ST(3))) {
	    IV tmp = SvIV((SV*)SvRV(ST(3)));
	    va_arg1 = INT2PTR(cfg_node_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "va_arg1 is not a reference");
#line 262 "cfg.xs"
            RETVAL = cfg_node_set(cfg, node, attr, va_arg1);
#line 456 "cfg.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    else if ((   (cfg_node_attr_t)SvIV(ST(2)) == CFG_NODE_ATTR_CHILDS \
           || (cfg_node_attr_t)SvIV(ST(2)) == CFG_NODE_ATTR_NODES  \
           || (cfg_node_attr_t)SvIV(ST(2)) == CFG_NODE_ATTR_DEPTH  \
           || (cfg_node_attr_t)SvIV(ST(2)) == CFG_NODE_ATTR_SRCPOS  ))
    {
	cfg_t *	cfg;
	cfg_node_t *	node;
	cfg_node_attr_t	attr = (cfg_node_attr_t)SvIV(ST(2));
	int	va_arg1 = (int)SvIV(ST(3));
	cfg_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    cfg = INT2PTR(cfg_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "cfg is not a reference");

	if (SvROK(ST(1))) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    node = INT2PTR(cfg_node_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "node is not a reference");
#line 275 "cfg.xs"
            RETVAL = cfg_node_set(cfg, node, attr, va_arg1);
#line 486 "cfg.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    else if ((   (cfg_node_attr_t)SvIV(ST(2)) == CFG_NODE_ATTR_SRCNAME \
           || (cfg_node_attr_t)SvIV(ST(2)) == CFG_NODE_ATTR_TOKEN    ))
    {
	cfg_t *	cfg;
	cfg_node_t *	node;
	cfg_node_attr_t	attr = (cfg_node_attr_t)SvIV(ST(2));
	char *	va_arg1 = (char *)SvPV_nolen(ST(3));
	cfg_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    cfg = INT2PTR(cfg_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "cfg is not a reference");

	if (SvROK(ST(1))) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    node = INT2PTR(cfg_node_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "node is not a reference");
#line 286 "cfg.xs"
            RETVAL = cfg_node_set(cfg, node, attr|CFG_ATTR_COPY, va_arg1);
#line 514 "cfg.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    else if (((cfg_node_attr_t)SvIV(ST(2)) == CFG_NODE_ATTR_TYPE))
    {
	cfg_t *	cfg;
	cfg_node_t *	node;
	cfg_node_attr_t	attr = (cfg_node_attr_t)SvIV(ST(2));
	cfg_node_type_t	va_arg1 = (cfg_node_type_t)SvIV(ST(3));
	cfg_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    cfg = INT2PTR(cfg_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "cfg is not a reference");

	if (SvROK(ST(1))) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    node = INT2PTR(cfg_node_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "node is not a reference");
#line 296 "cfg.xs"
            RETVAL = cfg_node_set(cfg, node, attr, va_arg1);
#line 541 "cfg.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    else if (((cfg_node_attr_t)SvIV(ST(2)) == CFG_NODE_ATTR_DATA))
    {
	cfg_t *	cfg;
	cfg_node_t *	node;
	cfg_node_attr_t	attr = (cfg_node_attr_t)SvIV(ST(2));
	cfg_data_t *	va_arg1;
	cfg_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    cfg = INT2PTR(cfg_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "cfg is not a reference");

	if (SvROK(ST(1))) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    node = INT2PTR(cfg_node_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "node is not a reference");

	if (SvROK(ST(3))) {
	    IV tmp = SvIV((SV*)SvRV(ST(3)));
	    va_arg1 = INT2PTR(cfg_data_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "va_arg1 is not a reference");
#line 306 "cfg.xs"
            RETVAL = cfg_node_set(cfg, node, attr, va_arg1);
#line 575 "cfg.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    else
    {
	cfg_t *	cfg;
	cfg_node_t *	node;
	cfg_node_attr_t	attr = (cfg_node_attr_t)SvIV(ST(2));
	cfg_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    cfg = INT2PTR(cfg_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "cfg is not a reference");

	if (SvROK(ST(1))) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    node = INT2PTR(cfg_node_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "node is not a reference");
#line 317 "cfg.xs"
            RETVAL = cfg_node_set(cfg, node, attr);
#line 601 "cfg.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_OSSP__cfg_cfg_node_get); /* prototype to pass -Wmissing-prototypes */
XS(XS_OSSP__cfg_cfg_node_get)
{
    dXSARGS;
    if (items != 4)
	Perl_croak(aTHX_ "Usage: OSSP::cfg::cfg_node_get(cfg, node, attr, va_arg1)");
    if ((   (cfg_node_attr_t)SvIV(ST(2)) == CFG_NODE_ATTR_PARENT \
           || (cfg_node_attr_t)SvIV(ST(2)) == CFG_NODE_ATTR_LBROTH \
           || (cfg_node_attr_t)SvIV(ST(2)) == CFG_NODE_ATTR_RBROTH \
           || (cfg_node_attr_t)SvIV(ST(2)) == CFG_NODE_ATTR_CHILD1 \
           || (cfg_node_attr_t)SvIV(ST(2)) == CFG_NODE_ATTR_CHILDL  ))
    {
	cfg_t *	cfg;
	cfg_node_t *	node;
	cfg_node_attr_t	attr = (cfg_node_attr_t)SvIV(ST(2));
	cfg_node_t *	va_arg1;
	cfg_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    cfg = INT2PTR(cfg_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "cfg is not a reference");

	if (SvROK(ST(1))) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    node = INT2PTR(cfg_node_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "node is not a reference");
#line 334 "cfg.xs"
            RETVAL = cfg_node_get(cfg, node, attr, &va_arg1);
#line 641 "cfg.c"
	sv_setref_pv(ST(3), Nullch, (void*)va_arg1);
	SvSETMAGIC(ST(3));
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    else if ((   (cfg_node_attr_t)SvIV(ST(2)) == CFG_NODE_ATTR_CHILDS \
           || (cfg_node_attr_t)SvIV(ST(2)) == CFG_NODE_ATTR_NODES  \
           || (cfg_node_attr_t)SvIV(ST(2)) == CFG_NODE_ATTR_DEPTH  \
           || (cfg_node_attr_t)SvIV(ST(2)) == CFG_NODE_ATTR_SRCPOS  ))
    {
	cfg_t *	cfg;
	cfg_node_t *	node;
	cfg_node_attr_t	attr = (cfg_node_attr_t)SvIV(ST(2));
	int	va_arg1;
	cfg_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    cfg = INT2PTR(cfg_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "cfg is not a reference");

	if (SvROK(ST(1))) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    node = INT2PTR(cfg_node_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "node is not a reference");
#line 348 "cfg.xs"
            RETVAL = cfg_node_get(cfg, node, attr, &va_arg1);
#line 673 "cfg.c"
	sv_setiv(ST(3), (IV)va_arg1);
	SvSETMAGIC(ST(3));
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    else if ((   (cfg_node_attr_t)SvIV(ST(2)) == CFG_NODE_ATTR_SRCNAME \
           || (cfg_node_attr_t)SvIV(ST(2)) == CFG_NODE_ATTR_TOKEN    ))
    {
	cfg_t *	cfg;
	cfg_node_t *	node;
	cfg_node_attr_t	attr = (cfg_node_attr_t)SvIV(ST(2));
	char *	va_arg1;
	cfg_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    cfg = INT2PTR(cfg_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "cfg is not a reference");

	if (SvROK(ST(1))) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    node = INT2PTR(cfg_node_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "node is not a reference");
#line 360 "cfg.xs"
            RETVAL = cfg_node_get(cfg, node, attr|CFG_ATTR_COPY, &va_arg1);
#line 703 "cfg.c"
	sv_setpv((SV*)ST(3), va_arg1);
	SvSETMAGIC(ST(3));
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    else if (((cfg_node_attr_t)SvIV(ST(2)) == CFG_NODE_ATTR_TYPE))
    {
	cfg_t *	cfg;
	cfg_node_t *	node;
	cfg_node_attr_t	attr = (cfg_node_attr_t)SvIV(ST(2));
	cfg_node_type_t	va_arg1;
	cfg_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    cfg = INT2PTR(cfg_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "cfg is not a reference");

	if (SvROK(ST(1))) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    node = INT2PTR(cfg_node_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "node is not a reference");
#line 371 "cfg.xs"
            RETVAL = cfg_node_get(cfg, node, attr, &va_arg1);
#line 732 "cfg.c"
	sv_setiv(ST(3), (IV)va_arg1);
	SvSETMAGIC(ST(3));
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    else if (((cfg_node_attr_t)SvIV(ST(2)) == CFG_NODE_ATTR_DATA))
    {
	cfg_t *	cfg;
	cfg_node_t *	node;
	cfg_node_attr_t	attr = (cfg_node_attr_t)SvIV(ST(2));
	cfg_data_t *	va_arg1;
	cfg_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    cfg = INT2PTR(cfg_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "cfg is not a reference");

	if (SvROK(ST(1))) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    node = INT2PTR(cfg_node_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "node is not a reference");
#line 382 "cfg.xs"
            RETVAL = cfg_node_get(cfg, node, attr, &va_arg1);
#line 761 "cfg.c"
	sv_setref_pv(ST(3), Nullch, (void*)va_arg1);
	SvSETMAGIC(ST(3));
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    else
    {
	cfg_t *	cfg;
	cfg_node_t *	node;
	cfg_node_attr_t	attr = (cfg_node_attr_t)SvIV(ST(2));
	cfg_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    cfg = INT2PTR(cfg_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "cfg is not a reference");

	if (SvROK(ST(1))) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    node = INT2PTR(cfg_node_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "node is not a reference");
#line 394 "cfg.xs"
            RETVAL = cfg_node_get(cfg, node, attr);
#line 789 "cfg.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_OSSP__cfg_cfg_node_root); /* prototype to pass -Wmissing-prototypes */
XS(XS_OSSP__cfg_cfg_node_root)
{
    dXSARGS;
    if (items != 3)
	Perl_croak(aTHX_ "Usage: OSSP::cfg::cfg_node_root(cfg, node, node_old)");
    {
	cfg_t *	cfg;
	cfg_node_t *	node;
	cfg_node_t *	node_old;
	cfg_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    cfg = INT2PTR(cfg_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "cfg is not a reference");

	if (SvROK(ST(1))) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    node = INT2PTR(cfg_node_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "node is not a reference");
#line 407 "cfg.xs"
        RETVAL = cfg_node_root(cfg, node, &node_old);
#line 823 "cfg.c"
	sv_setref_pv(ST(2), Nullch, (void*)node_old);
	SvSETMAGIC(ST(2));
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_OSSP__cfg_cfg_node_select); /* prototype to pass -Wmissing-prototypes */
XS(XS_OSSP__cfg_cfg_node_select)
{
    dXSARGS;
    if (items != 4)
	Perl_croak(aTHX_ "Usage: OSSP::cfg::cfg_node_select(cfg, node, result, spec)");
    {
	cfg_t *	cfg;
	cfg_node_t *	node;
	SV *	result;
	const char *	spec = (const char *)SvPV_nolen(ST(3));
#line 422 "cfg.xs"
        cfg_node_t **r;
#line 844 "cfg.c"
	cfg_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    cfg = INT2PTR(cfg_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "cfg is not a reference");

	if (SvROK(ST(1))) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    node = INT2PTR(cfg_node_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "node is not a reference");
#line 424 "cfg.xs"
        /* FIXME: perhaps use sv_vsetpvfn() to fully emulate C API? */
        RETVAL = cfg_node_select(cfg, node, &r, "%s", spec);
        if (RETVAL == CFG_OK) {
            /* translate C array into Perl array */
            int i;
            AV *av = newAV();
            for (i = 0; r[i] != NULL; i++)
                av_push(av, newSV(PTR2IV(r[i])));
            free(r);
            result = newRV_noinc((SV *)av);
        }
        else
            result = &PL_sv_undef;
#line 875 "cfg.c"
	ST(2) = result;
	SvSETMAGIC(ST(2));
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_OSSP__cfg_cfg_node_find); /* prototype to pass -Wmissing-prototypes */
XS(XS_OSSP__cfg_cfg_node_find)
{
    dXSARGS;
    if (items != 5)
	Perl_croak(aTHX_ "Usage: OSSP::cfg::cfg_node_find(cfg, node, cb_fct_cmp, cb_ctx_cmp, cont)");
    {
	cfg_t *	cfg;
	cfg_node_t *	node;
	SV *	cb_fct_cmp = ST(2);
	SV *	cb_ctx_cmp = ST(3);
	cfg_node_t *	cont;
#line 452 "cfg.xs"
        cb_ctx_t ctx_cmp;
#line 897 "cfg.c"
	cfg_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    cfg = INT2PTR(cfg_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "cfg is not a reference");

	if (SvROK(ST(1))) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    node = INT2PTR(cfg_node_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "node is not a reference");
#line 454 "cfg.xs"
        ctx_cmp.fct = cb_fct_cmp;
        ctx_cmp.ctx = cb_ctx_cmp;
        RETVAL = cfg_node_find(cfg, node, cb_fct, &ctx_cmp, &cont);
#line 918 "cfg.c"
	sv_setref_pv(ST(4), Nullch, (void*)cont);
	SvSETMAGIC(ST(4));
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_OSSP__cfg_cfg_node_apply); /* prototype to pass -Wmissing-prototypes */
XS(XS_OSSP__cfg_cfg_node_apply)
{
    dXSARGS;
    if (items != 6)
	Perl_croak(aTHX_ "Usage: OSSP::cfg::cfg_node_apply(cfg, node, cb_fct_cmp, cb_ctx_cmp, cb_fct_cb, cb_ctx_cb)");
    {
	cfg_t *	cfg;
	cfg_node_t *	node;
	SV *	cb_fct_cmp = ST(2);
	SV *	cb_ctx_cmp = ST(3);
	SV *	cb_fct_cb = ST(4);
	SV *	cb_ctx_cb = ST(5);
#line 473 "cfg.xs"
        cb_ctx_t ctx_cmp;
        cb_ctx_t ctx_cb;
#line 942 "cfg.c"
	cfg_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    cfg = INT2PTR(cfg_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "cfg is not a reference");

	if (SvROK(ST(1))) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    node = INT2PTR(cfg_node_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "node is not a reference");
#line 476 "cfg.xs"
        ctx_cmp.fct = cb_fct_cmp;
        ctx_cmp.ctx = cb_ctx_cmp;
        ctx_cb.fct  = cb_fct_cb;
        ctx_cb.ctx  = cb_ctx_cb;
        RETVAL = cfg_node_apply(cfg, node, cb_fct, &ctx_cmp, cb_fct, &ctx_cb);
#line 965 "cfg.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_OSSP__cfg_cfg_node_cmp); /* prototype to pass -Wmissing-prototypes */
XS(XS_OSSP__cfg_cfg_node_cmp)
{
    dXSARGS;
    if (items != 3)
	Perl_croak(aTHX_ "Usage: OSSP::cfg::cfg_node_cmp(cfg, node, token)");
    {
	cfg_t *	cfg;
	cfg_node_t *	node;
	char *	token = (char *)SvPV_nolen(ST(2));
	cfg_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    cfg = INT2PTR(cfg_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "cfg is not a reference");

	if (SvROK(ST(1))) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    node = INT2PTR(cfg_node_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "node is not a reference");
#line 493 "cfg.xs"
        RETVAL = cfg_node_cmp(cfg, node, (void *)token);
#line 999 "cfg.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_OSSP__cfg_cfg_node_link); /* prototype to pass -Wmissing-prototypes */
XS(XS_OSSP__cfg_cfg_node_link)
{
    dXSARGS;
    if (items != 4)
	Perl_croak(aTHX_ "Usage: OSSP::cfg::cfg_node_link(cfg, node, id, node2)");
    {
	cfg_t *	cfg;
	cfg_node_t *	node;
	cfg_node_attr_t	id = (cfg_node_attr_t)SvIV(ST(2));
	cfg_node_t *	node2;
	cfg_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    cfg = INT2PTR(cfg_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "cfg is not a reference");

	if (SvROK(ST(1))) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    node = INT2PTR(cfg_node_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "node is not a reference");

	if (SvROK(ST(3))) {
	    IV tmp = SvIV((SV*)SvRV(ST(3)));
	    node2 = INT2PTR(cfg_node_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "node2 is not a reference");
#line 507 "cfg.xs"
        RETVAL = cfg_node_link(cfg, node, id, node2);
#line 1041 "cfg.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_OSSP__cfg_cfg_node_unlink); /* prototype to pass -Wmissing-prototypes */
XS(XS_OSSP__cfg_cfg_node_unlink)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: OSSP::cfg::cfg_node_unlink(cfg, node)");
    {
	cfg_t *	cfg;
	cfg_node_t *	node;
	cfg_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    cfg = INT2PTR(cfg_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "cfg is not a reference");

	if (SvROK(ST(1))) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    node = INT2PTR(cfg_node_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "node is not a reference");
#line 519 "cfg.xs"
        RETVAL = cfg_node_unlink(cfg, node);
#line 1074 "cfg.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_OSSP__cfg_cfg_data_set); /* prototype to pass -Wmissing-prototypes */
XS(XS_OSSP__cfg_cfg_data_set)
{
    dXSARGS;
    if (items != 3)
	Perl_croak(aTHX_ "Usage: OSSP::cfg::cfg_data_set(data, attr, va_arg1)");
    if ((cfg_data_attr_t)SvIV(ST(1)) == CFG_DATA_ATTR_TYPE)
    {
	cfg_data_t *	data;
	cfg_data_attr_t	attr = (cfg_data_attr_t)SvIV(ST(1));
	cfg_data_type_t	va_arg1 = (cfg_data_type_t)SvIV(ST(2));
	cfg_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    data = INT2PTR(cfg_data_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "data is not a reference");
#line 533 "cfg.xs"
            RETVAL = cfg_data_set(data, attr, va_arg1);
#line 1102 "cfg.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    else if ((cfg_data_attr_t)SvIV(ST(1)) == CFG_DATA_ATTR_VALUE)
    {
	cfg_data_t *	data;
	cfg_data_attr_t	attr = (cfg_data_attr_t)SvIV(ST(1));
#line 541 "cfg.xs"
            cfg_data_type_t type;
#line 1111 "cfg.c"
	cfg_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    data = INT2PTR(cfg_data_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "data is not a reference");
#line 543 "cfg.xs"
            if ((RETVAL = cfg_data_get(data, CFG_DATA_ATTR_TYPE, &type)) == CFG_OK) {
                switch (type) {
                    case CFG_DATA_TYPE_PTR: {
                        void *va_arg1 = INT2PTR(cfg_node_t *, SvIV((SV*)SvRV(ST(2))));
                        RETVAL = cfg_data_set(data, attr, va_arg1);
                        break;
                    }
                    case CFG_DATA_TYPE_STR: {
                        char *va_arg1 = SvPV_nolen(ST(2));
                        RETVAL = cfg_data_set(data, attr, va_arg1);
                        break;
                    }
                    case CFG_DATA_TYPE_INT: {
                        int va_arg1 = SvIV(ST(2));
                        RETVAL = cfg_data_set(data, attr, va_arg1);
                        break;
                    }
                    case CFG_DATA_TYPE_FLT: {
                        double va_arg1 = SvNV(ST(2));
                        RETVAL = cfg_data_set(data, attr, va_arg1);
                        break;
                    }
                }
            }
#line 1146 "cfg.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    else if ((cfg_data_attr_t)SvIV(ST(1)) == CFG_DATA_ATTR_CTRL)
    {
	cfg_data_t *	data;
	cfg_data_attr_t	attr = (cfg_data_attr_t)SvIV(ST(1));
	cfg_data_cb_t	va_arg1;
	cfg_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    data = INT2PTR(cfg_data_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "data is not a reference");

	if (SvROK(ST(2))) {
	    IV tmp = SvIV((SV*)SvRV(ST(2)));
	    va_arg1 = INT2PTR(cfg_data_cb_t,tmp);
	}
	else
	    Perl_croak(aTHX_ "va_arg1 is not a reference");
#line 575 "cfg.xs"
            RETVAL = cfg_data_set(data, attr, va_arg1);
#line 1172 "cfg.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_OSSP__cfg_cfg_data_get); /* prototype to pass -Wmissing-prototypes */
XS(XS_OSSP__cfg_cfg_data_get)
{
    dXSARGS;
    if (items != 3)
	Perl_croak(aTHX_ "Usage: OSSP::cfg::cfg_data_get(data, attr, va_arg1)");
    if ((cfg_data_attr_t)SvIV(ST(1)) == CFG_DATA_ATTR_TYPE)
    {
	cfg_data_t *	data;
	cfg_data_attr_t	attr = (cfg_data_attr_t)SvIV(ST(1));
	cfg_data_type_t	va_arg1;
	cfg_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    data = INT2PTR(cfg_data_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "data is not a reference");
#line 589 "cfg.xs"
            RETVAL = cfg_data_get(data, attr, &va_arg1);
#line 1200 "cfg.c"
	sv_setiv(ST(2), (IV)va_arg1);
	SvSETMAGIC(ST(2));
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    else if ((cfg_data_attr_t)SvIV(ST(1)) == CFG_DATA_ATTR_VALUE)
    {
	cfg_data_t *	data;
	cfg_data_attr_t	attr = (cfg_data_attr_t)SvIV(ST(1));
	SV *	va_arg1 = ST(2);
#line 599 "cfg.xs"
            cfg_data_type_t type;
#line 1212 "cfg.c"
	cfg_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    data = INT2PTR(cfg_data_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "data is not a reference");
#line 601 "cfg.xs"
            if ((RETVAL = cfg_data_get(data, CFG_DATA_ATTR_TYPE, &type)) == CFG_OK) {
                switch (type) {
                    case CFG_DATA_TYPE_PTR: {
                        void *arg;
                        RETVAL = cfg_data_get(data, attr, &arg);
                        sv_setiv(va_arg1, PTR2IV(arg));
                        break;
                    }
                    case CFG_DATA_TYPE_STR: {
                        char *arg;
                        RETVAL = cfg_data_set(data, attr, &arg);
                        sv_setpv(va_arg1, arg);
                        break;
                    }
                    case CFG_DATA_TYPE_INT: {
                        int arg;
                        RETVAL = cfg_data_set(data, attr, &arg);
                        sv_setiv(va_arg1, arg);
                        break;
                    }
                    case CFG_DATA_TYPE_FLT: {
                        double arg;
                        RETVAL = cfg_data_set(data, attr, &arg);
                        sv_setnv(va_arg1, arg);
                        break;
                    }
                }
            }
#line 1251 "cfg.c"
	ST(2) = va_arg1;
	SvSETMAGIC(ST(2));
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    else if ((cfg_data_attr_t)SvIV(ST(1)) == CFG_DATA_ATTR_CTRL)
    {
	cfg_data_t *	data;
	cfg_data_attr_t	attr = (cfg_data_attr_t)SvIV(ST(1));
	cfg_data_cb_t	va_arg1;
	cfg_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    data = INT2PTR(cfg_data_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "data is not a reference");
#line 638 "cfg.xs"
            RETVAL = cfg_data_set(data, attr, &va_arg1);
#line 1272 "cfg.c"
	sv_setref_pv(ST(2), Nullch, (void*)va_arg1);
	SvSETMAGIC(ST(2));
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_OSSP__cfg_cfg_data_ctrl); /* prototype to pass -Wmissing-prototypes */
XS(XS_OSSP__cfg_cfg_data_ctrl)
{
    dXSARGS;
    if (items != 3)
	Perl_croak(aTHX_ "Usage: OSSP::cfg::cfg_data_ctrl(data, ctrl, va_arg1)");
    if ((cfg_data_ctrl_t)SvIV(ST(1)) == CFG_DATA_CTRL_CLONE)
    {
	cfg_data_t *	data;
	cfg_data_ctrl_t	ctrl = (cfg_data_ctrl_t)SvIV(ST(1));
	cfg_data_t *	va_arg1;
	cfg_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    data = INT2PTR(cfg_data_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "data is not a reference");
#line 653 "cfg.xs"
            RETVAL = cfg_data_ctrl(data, ctrl, &va_arg1);
#line 1302 "cfg.c"
	sv_setref_pv(ST(2), Nullch, (void*)va_arg1);
	SvSETMAGIC(ST(2));
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    else if ((cfg_data_attr_t)SvIV(ST(1)) == CFG_DATA_CTRL_DESTROY)
    {
	cfg_data_t *	data;
	cfg_data_ctrl_t	ctrl = (cfg_data_ctrl_t)SvIV(ST(1));
	cfg_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    data = INT2PTR(cfg_data_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "data is not a reference");
#line 662 "cfg.xs"
            RETVAL = cfg_data_ctrl(data, ctrl);
#line 1322 "cfg.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    else
    {
	cfg_data_t *	data;
	cfg_data_ctrl_t	ctrl = (cfg_data_ctrl_t)SvIV(ST(1));
	cfg_rc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    data = INT2PTR(cfg_data_t *,tmp);
	}
	else
	    Perl_croak(aTHX_ "data is not a reference");
#line 670 "cfg.xs"
            RETVAL = cfg_data_set(data, ctrl);
#line 1340 "cfg.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C"
#endif
XS(boot_OSSP__cfg); /* prototype to pass -Wmissing-prototypes */
XS(boot_OSSP__cfg)
{
    dXSARGS;
    char* file = __FILE__;

    XS_VERSION_BOOTCHECK ;

        newXS("OSSP::cfg::constant", XS_OSSP__cfg_constant, file);
        newXSproto("OSSP::cfg::cfg_create", XS_OSSP__cfg_cfg_create, file, "$");
        newXSproto("OSSP::cfg::cfg_destroy", XS_OSSP__cfg_cfg_destroy, file, "$");
        newXSproto("OSSP::cfg::cfg_error", XS_OSSP__cfg_cfg_error, file, "$$$");
        newXSproto("OSSP::cfg::cfg_version", XS_OSSP__cfg_cfg_version, file, "");
        newXSproto("OSSP::cfg::cfg_import", XS_OSSP__cfg_cfg_import, file, "$$$$$");
        newXSproto("OSSP::cfg::cfg_export", XS_OSSP__cfg_cfg_export, file, "$$$$$");
        newXSproto("OSSP::cfg::cfg_node_create", XS_OSSP__cfg_cfg_node_create, file, "$$");
        newXSproto("OSSP::cfg::cfg_node_destroy", XS_OSSP__cfg_cfg_node_destroy, file, "$$");
        newXSproto("OSSP::cfg::cfg_node_clone", XS_OSSP__cfg_cfg_node_clone, file, "$$$");
        newXSproto("OSSP::cfg::cfg_node_set", XS_OSSP__cfg_cfg_node_set, file, "$$$;$");
        newXSproto("OSSP::cfg::cfg_node_get", XS_OSSP__cfg_cfg_node_get, file, "$$$;$");
        newXSproto("OSSP::cfg::cfg_node_root", XS_OSSP__cfg_cfg_node_root, file, "$$");
        newXSproto("OSSP::cfg::cfg_node_select", XS_OSSP__cfg_cfg_node_select, file, "$$$$");
        newXSproto("OSSP::cfg::cfg_node_find", XS_OSSP__cfg_cfg_node_find, file, "$$$$$");
        newXSproto("OSSP::cfg::cfg_node_apply", XS_OSSP__cfg_cfg_node_apply, file, "$$$$$$");
        newXSproto("OSSP::cfg::cfg_node_cmp", XS_OSSP__cfg_cfg_node_cmp, file, "$$$");
        newXSproto("OSSP::cfg::cfg_node_link", XS_OSSP__cfg_cfg_node_link, file, "$$$$");
        newXSproto("OSSP::cfg::cfg_node_unlink", XS_OSSP__cfg_cfg_node_unlink, file, "$$");
        newXSproto("OSSP::cfg::cfg_data_set", XS_OSSP__cfg_cfg_data_set, file, "$$$");
        newXSproto("OSSP::cfg::cfg_data_get", XS_OSSP__cfg_cfg_data_get, file, "$$$");
        newXSproto("OSSP::cfg::cfg_data_ctrl", XS_OSSP__cfg_cfg_data_ctrl, file, "$$;$");
    XSRETURN_YES;
}

