#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#include <unistd.h>

#include "al.h"
#include "sio.h"

static char oddlabel, evenlabel;
#define ODDLABEL  ((al_label_t)&oddlabel)
#define EVENLABEL ((al_label_t)&evenlabel)

extern sio_module_t sio_module_fd;
extern sio_module_t sio_module_zlib;
extern sio_module_t sio_module_buffer;
extern sio_module_t sio_module_sio;
extern sio_module_t sio_module_sillymux;

#define e(f) rc = f; printf("%s = %s\n",#f, sio_error(rc)); fflush(stdout);
#define s(f) src = f; printf("%s = %s\n",#f, sa_error(src)); fflush(stdout);

int main(int argc, char *argv[])
{
    int fd;
    sio_rc_t rc;

    sio_t *sio;
    sio_stage_t *sios_fd, *sios_buffer, *sios_zlib;
    sio_stage_t *sios_sillymux;

    sio_t *sio2a;
    sio_stage_t *sios2a_sio;

    sio_t *sio2b;
    sio_stage_t *sios2b_sio;

    al_label_t label;

    char buf[513];
    size_t buflen;
    int level;
    size_t actual;

#ifdef WRITE
    fd = open("output", O_WRONLY|O_TRUNC|O_CREAT, 0666);

    {
        int i;
        for (i=0; i<sizeof(buf)-16; i += 16)
            sprintf(buf+i,"Hello world %03.3d\n",i);
        buf[i] = '\0';
    }

#else
    fd = open("output", O_RDONLY);
#endif

    e(sio_create(&sio));
    e(sio_create_stage(sio, &sio_module_fd, &sios_fd));
    e(sio_create_stage(sio, &sio_module_zlib, &sios_zlib));
    e(sio_create_stage(sio, &sio_module_buffer, &sios_buffer));
    e(sio_create_stage(sio, &sio_module_sillymux, &sios_sillymux));

    e(sio_configure_stage(sio, sios_fd, "fd", &fd));
    buflen = 512;
    e(sio_configure_stage(sio, sios_fd, "buflen", &buflen));

    buflen = 200;
    e(sio_configure_stage(sio, sios_buffer, "outputsize", &buflen));
    e(sio_configure_stage(sio, sios_buffer, "inputsize", &buflen));

    buflen = 200;
    e(sio_configure_stage(sio, sios_zlib, "outputsize", &buflen));
    e(sio_configure_stage(sio, sios_zlib, "inputsize", &buflen));
    level = 0;
    e(sio_configure_stage(sio, sios_zlib, "outputlevel", &level));
    level = -1;
    e(sio_configure_stage(sio, sios_zlib, "inputlevel", &level));

    e(sio_configure_stage(sio, sios_sillymux, "oddlabel", ODDLABEL));
    e(sio_configure_stage(sio, sios_sillymux, "evenlabel", EVENLABEL));

    e(sio_create(&sio2a));
    e(sio_create_stage(sio2a, &sio_module_sio, &sios2a_sio));
    e(sio_configure_stage(sio2a, sios2a_sio, "upstream", sio));
    e(sio_configure_stage(sio2a, sios2a_sio, "mydatalabel", ODDLABEL));
    e(sio_attach(sio2a, sios2a_sio, SIO_MODE_READWRITE));

    e(sio_create(&sio2b));
    e(sio_create_stage(sio2b, &sio_module_sio, &sios2b_sio));
    e(sio_configure_stage(sio2b, sios2b_sio, "upstream", sio));
    e(sio_configure_stage(sio2b, sios2b_sio, "mydatalabel", EVENLABEL));
    e(sio_attach(sio2b, sios2b_sio, SIO_MODE_READWRITE));


    {
        e(sio_attach(sio, sios_fd, SIO_MODE_READWRITE));
        e(sio_attach(sio, sios_zlib, SIO_MODE_READWRITE));
        e(sio_attach(sio, sios_buffer, SIO_MODE_READWRITE));
        e(sio_attach(sio, sios_sillymux, SIO_MODE_READWRITE));

#ifdef WRITE
        e(sio_write(sio2, buf, strlen(buf), &actual));
        e(sio_push(sio2));
#else
        do {

            printf("READ A\n");
            actual = 0;
            e(sio_read(sio2a, buf, sizeof(buf), &actual));
            printf("actual_a = %d\n",actual);
            fwrite(buf, actual, 1, stdout);
            printf("\n");

            printf("READ B\n");
            actual = 0;
            e(sio_read(sio2b, buf, sizeof(buf), &actual));
            printf("actual_b = %d\n",actual);
            fwrite(buf, actual, 1, stdout);
            printf("\n");

            printf("READ MUX\n");
            actual = 0;
            e(sio_read(sio, buf, sizeof(buf), &actual));
            printf("actual = %d\n",actual);
            fwrite(buf, actual, 1, stdout);
            printf("\n");

        } while (sio_flag(sio, SIO_FLAG_EOF) == SIO_FALSE);
#endif

        e(sio_detach(sio, sios_sillymux));
        e(sio_detach(sio, sios_buffer));
        e(sio_detach(sio, sios_zlib));
        e(sio_detach(sio, sios_fd));
    }

    e(sio_detach(sio2b, sios2b_sio));
    e(sio_destroy_stage(sio2b, sios2b_sio));
    e(sio_destroy(sio2b));

    e(sio_detach(sio2a, sios2a_sio));
    e(sio_destroy_stage(sio2a, sios2a_sio));
    e(sio_destroy(sio2a));

    e(sio_destroy_stage(sio, sios_buffer));
    e(sio_destroy_stage(sio, sios_zlib));
    e(sio_destroy_stage(sio, sios_fd));
    e(sio_destroy(sio));

    close(fd);

    return 0;
}
