//
//  OSSP asgui - Accounting system graphical user interface
//  Copyright (c) 2002-2003 The OSSP Project (http://www.ossp.org/)
//  Copyright (c) 2002-2003 Cable & Wireless Deutschland (http://www.cw.com/de/)
//  Copyright (c) 2002-2003 Ralf S. Engelschall <rse@engelschall.com>
//  Copyright (c) 2002-2003 Michael Schloh von Bennewitz <michael@schloh.com>
//
//  This file is part of OSSP asgui, an accounting system graphical user
//  interface which can be found at http://www.ossp.org/pkg/tool/asgui/.
//
//  Permission to use, copy, modify, and distribute this software for
//  any purpose with or without fee is hereby granted, provided that
//  the above copyright notice and this permission notice appear in all
//  copies.
//
//  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
//  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
//  IN NO EVENT SHALL THE AUTHORS AND COPYRIGHT HOLDERS AND THEIR
//  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
//  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
//  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
//  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
//  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
//  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
//  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
//  SUCH DAMAGE.
//
//  titraq.cpp: ISO C++ implementation
//

// User interface
#include "as_gui.h"     // Main classes
#include "as_except.h"  // Exception classes


//
// Construct a Titraqform which is a child of 'pParent', with the
// name 'kszName' and widget flags set to 'Flags'
//
Titraqform::Titraqform(QWidget *pParent,  const char *kszName, WFlags Flags) :
    QMainWindow(pParent, kszName, Flags)
{
    // Early member initialization
    this->setDirty(false);
    m_szFilename = new QString();

    // Initial widget manipulations
    if (!kszName)
        setName(trUtf8("Titraqform"));
    resize(TITRAQ_MAINWINWIDTH, TITRAQ_MAINWINHEIGHT);
    setCaption("OSSP Titraq");

//    // Lock down window size
//    setSizePolicy(QSizePolicy((QSizePolicy::SizeType)0,
//        (QSizePolicy::SizeType)0, 0, 0, sizePolicy().hasHeightForWidth()));

    // Abstractly build main widgets
    try {
        setupPrefs();
        setupActions();
        setupMenubar();
        setupFiletools();
        setupCentralwidget();
        setupStatusbar();
        setupTable();
        setupEditlay();
    }
    catch (Genexcept& Genex) {
        Genex.reportErr();
        exit(1);
    }

    m_pStatbar->message(trUtf8("Ready"));   // Signal a ready condition
}

//
// Destroy the object and free any allocated resources
//
Titraqform::~Titraqform(void)
{
    // Qt deletes child widgets for us
    m_pPrefs->flush();
    delete m_pPrefs;
}
