//
//  OSSP asgui - Accounting system graphical user interface
//  Copyright (c) 2002-2003 The OSSP Project (http://www.ossp.org/)
//  Copyright (c) 2002-2003 Cable & Wireless Deutschland (http://www.cw.com/de/)
//  Copyright (c) 2002-2003 Ralf S. Engelschall <rse@engelschall.com>
//  Copyright (c) 2002-2003 Michael Schloh von Bennewitz <michael@schloh.com>
//
//  This file is part of OSSP asgui, an accounting system graphical user
//  interface which can be found at http://www.ossp.org/pkg/tool/asgui/.
//
//  Permission to use, copy, modify, and distribute this software for
//  any purpose with or without fee is hereby granted, provided that
//  the above copyright notice and this permission notice appear in all
//  copies.
//
//  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
//  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
//  IN NO EVENT SHALL THE AUTHORS AND COPYRIGHT HOLDERS AND THEIR
//  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
//  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
//  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
//  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
//  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
//  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
//  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
//  SUCH DAMAGE.
//
//  titraq.h: ISO C++ interface
//

#ifndef AS_GUI_MWIN_H
#define AS_GUI_MWIN_H

#include <qapplication.h>
#include <qmainwindow.h>
#include <qaction.h>
#include <qtable.h>
#include <qmenubar.h>
#include <qtoolbar.h>
#include <qstatusbar.h>
#include <qimage.h>
#include <qdatetimeedit.h>
#include <qspinbox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qfile.h>

#include "as_const.h"   // For general constants
#include "as_pref.h"    // For class Preferences
#include "as_amount.h"  // For class AmountBox
#include "as_table.h"   // For class TiTable

// Intentional no operation
#define TITRAQ_NOP ((void)0)


// Main table size
const int g_knBlocks = 32;
const int g_knCols = 6;

// Styles enumeration
typedef enum
{
    TITRAQ_STYLECDE,
    TITRAQ_STYLESGI,
    TITRAQ_STYLEMOTIF,
    TITRAQ_STYLEMPLUS,
    TITRAQ_STYLEPLAT,
    TITRAQ_STYLEMSOFT
} styles_t;

// Main application form window
class Titraqform : public QMainWindow
{
    Q_OBJECT    // Generate MOC object model stubs

public:
    Titraqform(QWidget *pParent = 0, const char *kszName = 0, WFlags Flags = 0);
    ~Titraqform(void);

    // Accessor methods
    const bool isDirty(void) {return m_bDirt;};             // Check for changed state danger
    void setDirty(bool bDirty = true) {m_bDirt = bDirty;};  // Clean or dirty
    const QString getRowdata(void) const;                   // Get a whole row of data
    void setRowdata(QString &) const;                       // Set a whole row of data

    // Top level members
    Preferences *m_pPrefs;

    // Main application actions
    QAction     *m_pFilenewact,   *m_pFileopenact;
    QAction     *m_pFilesaveact,  *m_pFilesaveasact;
    QAction     *m_pFilecloseact, *m_pFilequitact;
    QAction     *m_pAddrowact,    *m_pDelrowact;
    QAction     *m_pCutact,       *m_pCopyact;
    QAction     *m_pPasteact,     *m_pWritedataact;

    // Table, cells, and entries in package layout
    TiTable     *m_pMaintable;
    QHeader     *m_pTablehead;
    QStringList *m_pTaskentries;

    // Edition widgets
    QDate       *m_pDatezero;           // Hack to store empty date
    QDateEdit   *m_pDateedit;           // Control used to edit dates
    QTimeEdit   *m_pStarttime;          // Control used to edit start time
    QTimeEdit   *m_pEndtime;            // Control used to edit finish time
    AmountBox   *m_pAmount;             // Control used to edit total time
    QComboBox   *m_pTasks;              // Control used to choose a task
    QLineEdit   *m_pRemark;             // Control used to edit remark

protected slots:
    void cutEntry(void);                // Cut task entries from the list
    void copyEntry(void);               // Copy task entries from the list
    void pasteEntry(void);              // Paste task entries to the list
    void addEntry(int nRows= -1);       // Add task entries to the list
    void delEntry(int nRows= -1);       // Delete task entries from the list
    void newDoc(void);                  // Make and display a new document window
    void openDoc(void);                 // Open and display an existing document
    void saveFile(void);                // Serialize to the current file
    void saveAs(void);                  // Serialize to a selected file
    void helpContents(void);            // Use the help contents
    void aboutTitraq(void);             // Learn more about this program itself
    void aboutOSSP(void);               // Learn more about the OSSP
    void aboutQt(void);                 // Learn more about Qt
    void selAll(void);                  // Edit menu select all
    void inplaceEdit(int, int, int, const QPoint &); // Enter in place edit mode
    void updEdit(int, int);             // Update edit controls
    void updSizes(int, int, int);       // Update edit sizes
    void dataChanged(int, int);         // Timesheet data changed
    void updateDate(const QDate &);     // Update date column
    void updateStart(const QTime &);    // Update start column
    void updateFinish(const QTime &);   // Update finish column
    void updateAmount(const QString &); // Update amount column
    void updateTask(const QString &);   // Update task column
    void updateRemark(const QString &); // Update remark column
    void confirmEdit(void);             // Confirm whole row edition
    void configPrefs(void);             // Edit menu configure preferences
    void normalView(void);              // View menu normal
    void editingView(void);             // View menu editing
    void timingView(void);              // View menu timing
    void showFilebar(void);             // View menu show file toolbar
    void showEditbar(void);             // View menu show edit toolbar
    void showWhatsbar(void);            // View menu show whats this toolbar
    void showLinecol(void);             // View menu show line numbers column
    void showGuidcol(void);             // View menu show GUIDs column
    void showDatecol(void);             // View menu show Dates column
    void showUsercol(void);             // View menu show Users column
    void showTaskcol(void);             // View menu show Tasks column
    void showStartcol(void);            // View menu show Start time column
    void showFinishcol(void);           // View menu show Finish time column
    void showAmountcol(void);           // View menu show Amounts column
    void showRemarkcol(void);           // View menu show Remarks column

protected:
    // Application main events
    void closeEvent(QCloseEvent *);     // Close current document in main window

    // Application main window widgets
    QFrame      *m_pCenframe;           // Central frame
    QVBoxLayout *m_pMainlayout;         // Package and control layouts
    QVBoxLayout *m_pPackagelayout;      // Main table control
    QHBoxLayout *m_pEditlayout;         // Lower edition widgets

private:
    // Owned by QMainWindow
    QMenuBar    *m_pMenubar;
    QPopupMenu  *m_pViewpopup;          // Saved for manipulating views
    QPopupMenu  *m_pTbarspopup;         // Saved for manipulating toolbars
    QPopupMenu  *m_pColspopup;          // Saved for manipulating columns
    QStatusBar  *m_pStatbar;

    // Belong to us
    QToolBar    *m_pFiletools;
    QToolBar    *m_pEdittools;
    QToolBar    *m_pWhatstools;
    QString     *m_szFilename;

    // Standard members
    bool        m_bDirt;                    // To track dirty and clean states

    // Constructor helpers
    void setupPrefs(void);              // Preferences
    void setupActions(void);            // Actions
    void setupMenubar(void);            // Menu bar
    void setupFiletools(void);          // Tool bar
    void setupStatusbar(void);          // Status bar
    void setupCentralwidget(void);      // Assemble main Frame widget
    void setupTable(void);              // Table widget
    void setupEditlay(void);            // Editing lay
    void setupPieces(void);             // Assemble widget pieces

    // Data processing
    void loadData(QFile &);             // Load accounting data from file
    void loadData(QTextStream &);       // Load accounting data from stream
    void saveData(QFile &);             // Save accounting data to file
    void saveData(QTextStream &);       // Save accounting data to stream
};

#endif // AS_GUI_MWIN_H
