//
//  OSSP asgui - Accounting system graphical user interface
//  Copyright (c) 2002-2003 The OSSP Project (http://www.ossp.org/)
//  Copyright (c) 2002-2003 Cable & Wireless Deutschland (http://www.cw.com/de/)
//  Copyright (c) 2002-2003 Ralf S. Engelschall <rse@engelschall.com>
//  Copyright (c) 2002-2003 Michael Schloh von Bennewitz <michael@schloh.com>
//
//  This file is part of OSSP asgui, an accounting system graphical user
//  interface which can be found at http://www.ossp.org/pkg/tool/asgui/.
//
//  Permission to use, copy, modify, and distribute this software for
//  any purpose with or without fee is hereby granted, provided that
//  the above copyright notice and this permission notice appear in all
//  copies.
//
//  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
//  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
//  IN NO EVENT SHALL THE AUTHORS AND COPYRIGHT HOLDERS AND THEIR
//  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
//  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
//  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
//  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
//  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
//  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
//  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
//  SUCH DAMAGE.
//
//  as_util.cpp: ISO C++ implementation
//

#include "as_gui.h"
#include "as_tableitem.h"


//
// Get a whole row of data
//
const QString Titraqform::getRowdata(void) const
{
    QString Rowdata;                                        // For output string
    QTableSelection Select = m_pMaintable->selection(0);    // Highlighted text
    int nTotal = Select.bottomRow() - Select.topRow() + 1;  // Total row select

    // Calculate rows to delete from selection highlight
    for (int nIter = 0; nIter < nTotal; ++nIter) {
        // Build the row data string one field at a time, adding seps inbetween
        Rowdata += m_pMaintable->text(Select.topRow() + nIter, TITRAQ_IDXDATE);
        Rowdata += trUtf8(TITRAQ_SEPARATORTOK);
    //    Rowdata += m_pMaintable->text(Select.topRow() + nIter, TITRAQ_IDXUSER);
    //    Rowdata += trUtf8(TITRAQ_SEPARATORTOK);
        Rowdata += m_pMaintable->text(Select.topRow() + nIter, TITRAQ_IDXSTART);
        Rowdata += trUtf8(TITRAQ_SEPARATORTOK);
        Rowdata += m_pMaintable->text(Select.topRow() + nIter, TITRAQ_IDXFINISH);
        Rowdata += trUtf8(TITRAQ_SEPARATORTOK);
        Rowdata += m_pMaintable->text(Select.topRow() + nIter, TITRAQ_IDXAMOUNT);
        Rowdata += trUtf8(TITRAQ_SEPARATORTOK);
        Rowdata += m_pMaintable->text(Select.topRow() + nIter, TITRAQ_IDXTASK);
        Rowdata += trUtf8(TITRAQ_SEPARATORTOK);
        Rowdata += m_pMaintable->text(Select.topRow() + nIter, TITRAQ_IDXREMARK);
        Rowdata += trUtf8("\n");    // Finish off line
    }

    return Rowdata;
}

//
// Set a whole row of data
//
void Titraqform::setRowdata(QString &Rowdata) const
{
    int nRows = Rowdata.contains(QChar('\n'));          // Set so many rows
    int nCurrentrow = m_pMaintable->currentRow();       // Current table row
    QTableItem *pItem = NULL;                           // Old item to change out
    QString Date, Start, Finish, Amount, Task, Remark;  // Text fields in table
    QTextStream Datastream(&Rowdata, IO_ReadOnly);      // Convert data to stream

    for (int nIter = 0; nIter < nRows; ++nIter) {
        Datastream >> Date >> Start;                    // Stream data fields
        Datastream >> Finish >> Amount >> Task;         // to corresponding vars
        Datastream.skipWhiteSpace();                    // Remove whitespaces
        Remark = Datastream.readLine();                 // Remark is a whole line

        // Set the table row data one field at a time, skipping seps inbetween
        m_pMaintable->setText(nCurrentrow + nIter, TITRAQ_IDXDATE, Date);
//        m_pMaintable->setText(nCurrentrow + nIter, TITRAQ_IDXUSER, User);
        m_pMaintable->setText(nCurrentrow + nIter, TITRAQ_IDXSTART, Start);
        m_pMaintable->setText(nCurrentrow + nIter, TITRAQ_IDXFINISH, Finish);
        m_pMaintable->setText(nCurrentrow + nIter, TITRAQ_IDXAMOUNT, Amount);

//        // FIXME: Why doesn't this code change the RtTableItem text in place?
//        RtTableItem *pTask = NULL;                      // Derived and special
//        pItem = m_pMaintable->item(nCurrentrow + nIter, TITRAQ_IDXTASK);
//        pTask = static_cast<RtTableItem *>(pItem);
//        pTask->setText(Task);

        // Change out old item and replace with new task data
        pItem = m_pMaintable->item(nCurrentrow + nIter, TITRAQ_IDXTASK);
        delete(pItem);  // Get rid of the old before going with the new
        m_pMaintable->setItem(nCurrentrow + nIter, TITRAQ_IDXTASK, new RtTableItem(m_pMaintable, QTableItem::WhenCurrent, Task));

        // Continue with field processing business as usual
        m_pMaintable->setText(nCurrentrow + nIter, TITRAQ_IDXREMARK, Remark);
    }
}
