
#ifndef __MSG_H__
#define __MSG_H__

#include <sys/types.h>

typedef struct {
    char   *azEnvgroups;  /* Groups according to Envelope in GROUPMODE_ENVELOPE */
    size_t  asEnvgroups;
    char   *cpMsg;      /* the wholly message to be received by DATA command */
    char   *azHeaders;  /* header part of message above */
    size_t  asHeaders;
    char   *cpBody;     /* body part of message above */
    char   *cpMsgid;
    char   *mail_from;
    char   *azRcpt;
    size_t  asRcpt;
    char   *azNewsgroups;
    size_t  asNewsgroups;
} msg_t;

#define WRAPAT 120          /* join wraps header lines when exceeding this value */
#define WRAPUSING "\n    "  /* join inserts this value when wrapping lines       */

typedef enum {
    MSG_OK,
    MSG_ERR_MEM,
    MSG_ERR_SPLITSPLITBODY,
    MSG_ERR_SPLITLEN,
    MSG_ERR_SPLITMISSINGFROM,
    MSG_ERR_SPLITIDNONE,
    MSG_ERR_SPLITIDEMPTY,
    MSG_ERR_SPLITIDMULTI,
    MSG_ERR_JOINGROUPNONE,
    MSG_ERR_JOINGROUPEMPTY,
    MSG_ERR_JOINIDNONE,
    MSG_ERR_JOINIDEMPTY,
    MSG_ERR_ARG
} msg_rc_t;

msg_t    *msg_create(void);
msg_rc_t  msg_split(msg_t *);
msg_rc_t  msg_join(msg_t *);
void      msg_destroy(msg_t *);
char     *msg_error(msg_rc_t);

#endif /*  __MSG_H__ */

