/*
**  L2 - OSSP Logging Library
**  Copyright (c) 2001 The OSSP Project (http://www.ossp.org/)
**  Copyright (c) 2001 Cable & Wireless Deutschland (http://www.cw.com/de/)
**
**  This file is part of OSSP L2, a flexible logging library which
**  can be found at http://www.ossp.org/pkg/l2/.
**
**  Permission to use, copy, modify, and distribute this software for
**  any purpose with or without fee is hereby granted, provided that
**  the above copyright notice and this permission notice appear in all
**  copies.
**
**  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
**  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
**  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
**  IN NO EVENT SHALL THE AUTHORS AND COPYRIGHT HOLDERS AND THEIR
**  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
**  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
**  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
**  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
**  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
**  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
**  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
**  SUCH DAMAGE.
**
**  l2_ut_sa.h: socket abstraction library
*/

#ifndef __L2_UT_SA_H__
#define __L2_UT_SA_H__

#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>

struct sa_st;
typedef struct sa_st sa_t;

struct sa_addr_st;
typedef struct sa_addr_st sa_addr_t;

typedef enum {
    SA_OK,
    SA_ERR_ARG,
    SA_ERR_USE,
    SA_ERR_MEM,
    SA_ERR_SYS,
    SA_ERR_INT
} sa_rc_t;

sa_rc_t sa_u2a      (sa_addr_t **asaa, const char *uri, ...);
sa_rc_t sa_s2a      (sa_addr_t **saa, const struct sockaddr *sabuf, socklen_t salen);
sa_rc_t sa_a2u      (const sa_addr_t *saa, char **uri);
sa_rc_t sa_a2s      (const sa_addr_t *saa, struct sockaddr **sabuf, socklen_t *salen);

sa_rc_t sa_create   (sa_t **sa);
sa_rc_t sa_destroy  (sa_t *sa);

sa_rc_t sa_timeout  (sa_t *sa, long sec, long usec);
sa_rc_t sa_buffers  (sa_t *sa, size_t rsize, size_t wsize);

sa_rc_t sa_bind     (sa_t *sa, sa_addr_t *laddr);
sa_rc_t sa_connect  (sa_t *sa, sa_addr_t *raddr);
sa_rc_t sa_listen   (sa_t *sa);
sa_rc_t sa_accept   (sa_t *sa, sa_t **sa_new);

sa_rc_t sa_getremote(sa_t *sa, sa_addr_t *raddr);
sa_rc_t sa_getlocal (sa_t *sa, sa_addr_t *laddr);

sa_rc_t sa_read     (sa_t *sa, char *buf, size_t buflen, size_t *bufdone);
sa_rc_t sa_readfrom (sa_t *sa, char *buf, size_t buflen, size_t *bufdone, sa_addr_t *addr);
sa_rc_t sa_readline (sa_t *sa, char *buf, size_t buflen, size_t *bufdone);
sa_rc_t sa_write    (sa_t *sa, const char *buf, size_t buflen, size_t *bufdone);
sa_rc_t sa_writeto  (sa_t *sa, const char *buf, size_t buflen, size_t *bufdone, sa_addr_t *addr);
sa_rc_t sa_printf   (sa_t *sa, const char *fmt, ...);
sa_rc_t sa_flush    (sa_t *sa);
sa_rc_t sa_shutdown (sa_t *sa, char *flags);

#endif /* __L2_UT_SA_H__ */

