#/bin/sh

newmsg()
{
    if [ -r testmessage.via${1} ]
    then
        awk <testmessage.via${1} \
         -v pid=$$ \
         -v id=I${H}${Z}${E}D \
         -v date=`date +%Y%m%d%H%M%S` \
         '
            BEGIN          { gotit = 0; IGNORECASE = 1 }
            /^#$/          { gotit = 1; print "#" date " [" pid "] " id }
            /^Message-ID:/ { gotit = 1; print "Message-Id: <" date "-" id "@dev12.dev.de.cw.net>" }
            /^Subject:/    { gotit = 1; print "Subject: [" pid "] " $2 }
                           { if (gotit == 0) { print }; gotit = 0 }
         ' | tee 2>&1 >/dev/null ${STDIN}
    else
        echo "ERROR: file testmessage.via${1} not readable!"
        exit 1
    fi
}

prolog ()
{
    H="0"; Z="0"; E="0"; #HZE used for mass-tests with uniq IDs

    for i in ${FILE} ${STDIN} ${STDOUT} ${STDERR} dmalloc.log
    do
        if [ -e ${i} ]; then
            rm -f ${i}
        fi
        touch ${i}
        chmod 666 ${i}
    done
}

epilog ()
{
    for i in ${FILE} ${STDIN} ${STDOUT} ${STDERR} dmalloc.log
    do
    if [ -r ${i} ]; then
        echo -n "press RETURN to see the contents of ${i}"
        read DUMMY
        less -S ${i}
    fi
    done
}

#main ()

   LOG="notice"
  FILE="stdlog"
 STDIN="stdin"
STDOUT="stdout"
STDERR="stderr"
 LOCAL="0.0.0.0"
  HOST="0.0.0.0"
 GROUP="my.test"
MFILT=".+@(?:[^.]+\.)*cw\.com"
 NODE="gateway"

# make check with automatic succeed/ fail message.
# more samples and testing below.

echo -n "check: -v verbose "
# expected sample output: lmtp2nntp 0.9.4 (30-Aug-2001)
prolog
newmsg lmtp
../lmtp2nntp -v >${STDOUT} 2>${STDERR}
RC=`cat ${STDOUT} | egrep 'lmtp2nntp[ ]+[0-9]+\.[0-9]\.[0-9][ ]+\([0-9]+-(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)-[0-9]{4}\)' | wc -l`
if [ ${RC} -ne 1 -o -s ${STDERR} ]; then
    echo "ERROR (got ${RC})"
    exit 1;
fi
echo "succeeded"
egrep <dmalloc.log -C 'not freed' >>sum.dmalloc.log

echo -n "check: -? usage "
# expected typical output: USAGE: ../lmtp2nntp
# lmtp2nntp [-b bindaddr[:port]] [-d deliverymode] [-g groupmode] [-h
# host[:port][,host[:port], ...]] [-m mailfrom] [-n nodename] [-s size] [-l
# level[:logfile]] [-v] [-w waittime] newsgroup [newsgroup ...]
prolog
newmsg lmtp
../lmtp2nntp -? >${STDOUT} 2>${STDERR}
RC=`cat ${STDERR} | egrep -- '-b.*-d.*-g.*-h.*-m.*-n.*-s.*-l.*-v.*-w.*newsgroup' | wc -l`
if [ ${RC} -ne 1 -o -s ${STDOUT} ]; then
    echo "ERROR (got ${RC})"
    exit 1;
fi
echo "succeeded"
egrep <dmalloc.log -C 'not freed' >>sum.dmalloc.log

echo -n "check: -- valid fake posting "
prolog
newmsg lmtp
../lmtp2nntp <${STDIN} -b ${LOCAL} -d 250/2.0.0 -g arg -h ${HOST} -l ${LOG}:${FILE} -m "${MFILT}" -n ${NODE} -s 1000 -w 1 ${GROUP} >${STDOUT} 2>${STDERR} ; RC=$
RC="";
if [ 1 -eq `egrep <${STDOUT} '^220[ -]LMTP Service ready'       | wc -l` ]; then RC="${RC}init "; fi
if [ 1 -eq `egrep <${STDOUT} '^250[ -].*pleased to meet you'    | wc -l` ]; then RC="${RC}LHLO "; fi
if [ 1 -eq `egrep <${STDOUT} '^250[ -]2.1.0 Sender ok'          | wc -l` ]; then RC="${RC}MAIL "; fi
if [ 3 -eq `egrep <${STDOUT} '^250[ -]2.1.5 Recipient accepted' | wc -l` ]; then RC="${RC}RCPT "; fi
if [ 1 -eq `egrep <${STDOUT} '^354[ -]Enter mail'               | wc -l` ]; then RC="${RC}DATA "; fi
if [ 3 -eq `egrep <${STDOUT} '^250[ -]2.0.0 NNTP noop fake'     | wc -l` ]; then RC="${RC}post "; fi
if [ 1 -eq `egrep <${STDOUT} '^221[ -]2.0.0.+closing.+channel'  | wc -l` ]; then RC="${RC}QUIT "; fi
if [ "${RC}" != "init LHLO MAIL RCPT DATA post QUIT " ]; then
    echo "ERROR (got ${RC})"
    exit 1;
fi
echo "succeeded"
egrep <dmalloc.log -C 'not freed' >>sum.dmalloc.log

echo -n "check: -m fake posting invalid sender "
prolog
newmsg lmtp
( MFILT=".*@is.invalid" ; ../lmtp2nntp <${STDIN} -b ${LOCAL} -d 250/2.0.0 -g arg -h ${HOST} -l ${LOG}:${FILE} -m "${MFILT}" -n ${NODE} -s 1000 -w 1 ${GROUP} >${STDOUT} 2>${STDERR} ) ; RC=$?
RC="";
if [ 1 -eq `egrep <${STDOUT} '^220[ -]LMTP Service ready'       | wc -l` ]; then RC="${RC}init "; fi
if [ 1 -eq `egrep <${STDOUT} '^250[ -].+pleased to meet you'    | wc -l` ]; then RC="${RC}LHLO "; fi
if [ 1 -eq `egrep <${STDOUT} '^550[ -]5.7.1.+not authorized'    | wc -l` ]; then RC="${RC}MAIL "; fi
if [ 3 -eq `egrep <${STDOUT} '^503[ -]5.5.0.+MAIL first'        | wc -l` ]; then RC="${RC}RCPT "; fi
if [ 1 -eq `egrep <${STDOUT} '^503[ -]5.5.0.+RCPT first'        | wc -l` ]; then RC="${RC}DATA "; fi
if [ 0 -lt `egrep <${STDOUT} '^500[ -]5.5.1.+unrecognized'      | wc -l` ]; then RC="${RC}post "; fi
if [ 1 -eq `egrep <${STDOUT} '^221[ -]2.0.0.+closing.+channel'  | wc -l` ]; then RC="${RC}QUIT "; fi
if [ "${RC}" != "init LHLO MAIL RCPT DATA post QUIT " ]; then
    echo "ERROR (got ${RC})"
    exit 1;
fi
echo "succeeded"
egrep <dmalloc.log -C 'not freed' >>sum.dmalloc.log

echo -n "check: -s fake posting invalid size "
prolog
newmsg lmtp
../lmtp2nntp <${STDIN} -b ${LOCAL} -d 250/2.0.0 -g arg -h ${HOST} -l ${LOG}:${FILE} -m "${MFILT}" -n ${NODE} -s 100  -w 1 ${GROUP} >${STDOUT} 2>${STDERR} ; RC=$?
RC="";
if [ 1 -eq `egrep <${STDOUT} '^220[ -]LMTP Service ready'       | wc -l` ]; then RC="${RC}init "; fi
if [ 1 -eq `egrep <${STDOUT} '^250[ -].*pleased to meet you'    | wc -l` ]; then RC="${RC}LHLO "; fi
if [ 1 -eq `egrep <${STDOUT} '^250[ -]2.1.0 Sender ok'          | wc -l` ]; then RC="${RC}MAIL "; fi
if [ 3 -eq `egrep <${STDOUT} '^250[ -]2.1.5 Recipient accepted' | wc -l` ]; then RC="${RC}RCPT "; fi
if [ 1 -eq `egrep <${STDOUT} '^354[ -]Enter mail'               | wc -l` ]; then RC="${RC}DATA "; fi
if [ 3 -eq `egrep <${STDOUT} '^552[ -]5.2.3.+exceeds.+limit'    | wc -l` ]; then RC="${RC}post "; fi
if [ 1 -eq `egrep <${STDOUT} '^221[ -]2.0.0.+closing.+channel'  | wc -l` ]; then RC="${RC}QUIT "; fi
if [ "${RC}" != "init LHLO MAIL RCPT DATA post QUIT " ]; then
    echo "ERROR (got ${RC})"
    exit 1;
fi
echo "succeeded"
egrep <dmalloc.log -C 'not freed' >>sum.dmalloc.log

echo -n "check: -b with invalid address "
prolog
newmsg lmtp
( LOCAL="127.0.0.255" ; ../lmtp2nntp <${STDIN} -b ${LOCAL} -d 250/2.0.0 -g arg -h ${HOST} -l ${LOG}:${FILE} -m "${MFILT}" -n ${NODE} -s 1000 -w 1 ${GROUP} >${STDOUT} 2>${STDERR} ) ; RC=$?
RC="";
if [ 1 -eq `egrep <${STDOUT} '^220[ -]LMTP Service ready'       | wc -l` ]; then RC="${RC}init "; fi
if [ 1 -eq `egrep <${FILE}   'error.+binding.+49'               | wc -l` ]; then RC="${RC}bind "; fi
if [ "${RC}" != "init bind " ]; then
    echo "ERROR (got ${RC})"
    exit 1;
fi
echo "succeeded"
egrep <dmalloc.log -C 'not freed' >>sum.dmalloc.log

echo -n "check: -g envelope with invalid group "
prolog
newmsg lmtp
( GROUP="foo.*" ; ../lmtp2nntp <${STDIN} -b ${LOCAL} -d 250/2.0.0 -g envelope -h ${HOST} -l ${LOG}:${FILE} -m "${MFILT}" -n ${NODE} -s 1000 -w 1 ${GROUP} >${STDOUT} 2>${STDERR} ) ; RC=$?
RC="";
if [ 1 -eq `egrep <${STDOUT} '^220[ -]LMTP Service ready'       | wc -l` ]; then RC="${RC}init "; fi
if [ 1 -eq `egrep <${STDOUT} '^250[ -].*pleased to meet you'    | wc -l` ]; then RC="${RC}LHLO "; fi
if [ 1 -eq `egrep <${STDOUT} '^250[ -]2.1.0 Sender ok'          | wc -l` ]; then RC="${RC}MAIL "; fi
if [ 1 -eq `egrep <${STDOUT} '^550[ -]5.7.2 unmatched Group'    | wc -l` ]; then RC="${RC}RCPT "; fi
if [ 2 -eq `egrep <${STDOUT} '^250[ -]2.1.5 Group accepted'     | wc -l` ]; then RC="${RC}RCPT "; fi
if [ 1 -eq `egrep <${STDOUT} '^354[ -]Enter mail'               | wc -l` ]; then RC="${RC}DATA "; fi
if [ 2 -eq `egrep <${STDOUT} '^250[ -]2.0.0 NNTP noop fake'     | wc -l` ]; then RC="${RC}post "; fi
if [ 1 -eq `egrep <${STDOUT} '^221[ -]2.0.0.+closing.+channel'  | wc -l` ]; then RC="${RC}QUIT "; fi
if [ "${RC}" != "init LHLO MAIL RCPT RCPT DATA post QUIT " ]; then
    echo "ERROR (got ${RC})"
    exit 1;
fi
echo "succeeded"
egrep <dmalloc.log -C 'not freed' >>sum.dmalloc.log

echo -n "check: -h fake posting to invalid host "
prolog
newmsg lmtp
( HOST="127.0.0.255" ; ../lmtp2nntp <${STDIN} -b ${LOCAL} -d 250/2.0.0 -g arg -h ${HOST} -l ${LOG}:${FILE} -m "${MFILT}" -n ${NODE} -s 1000 -w 1 ${GROUP} >${STDOUT} 2>${STDERR} ) ; RC=$?
RC="";
if [ 1 -eq `egrep <${STDOUT} '^220[ -]LMTP Service ready'       | wc -l` ]; then RC="${RC}init "; fi
if [ 1 -eq `egrep <${FILE}   'warning.+connect.+failed'         | wc -l` ]; then RC="${RC}conn "; fi
if [ "${RC}" != "init conn " ]; then
    echo "ERROR (got ${RC})"
    exit 1;
fi
echo "succeeded"
egrep <dmalloc.log -C 'not freed' >>sum.dmalloc.log

echo "CHECK COMPLETE AND PASSED"
#epilog
exit 0
