.TH PSNUP 1 "PSUtils Release @RELEASE@ Patchlevel @PATCHLEVEL@"
.SH NAME
psnup \- multiple pages per sheet
.SH SYNOPSIS
.B psnup
[
.B \-w\fIwidth\fR
] [
.B \-h\fIheight\fR
] [
.B \-p\fIpaper\fR
] [
.B \-l
] [
.B \-r
] [
.B \-f
] [
.B \-c
] [
.B \-m\fImargin\fR
] [
.B \-b\fIborder\fR
] [
.B \-d\fIlwidth\fR
] [
.B \-s\fIscale\fR
] [
.B \-\fInup\fR
] [
.B \-q
] [
.I infile
[
.I outfile
] ]
.SH DESCRIPTION
.I Psnup
puts multiple logical pages onto each physical sheet of paper.
The input PostScript file should follow the Adobe Document Structuring
Conventions.
.PP
The
.I \-w
option gives the paper width, and the
.I \-h
option gives the paper height,
normally specified in
.B "cm"
or
.B "in"
to convert 
PostScript's points (1/72 of an inch)
to centimeters or inches.
The 
.I \-p
option can be used as an alternative, to set the paper size to
.B a3, a4, a5, b5, letter, legal, tabloid, statement, executive, folio, quarto
or
.B 10x14.
The default paper size is
.B @PAPER@.
.PP
The
.I \-l
option should be used for pages which are in landscape orientation (rotated 90
degrees anticlockwise). The
.I \-r
option should be used for pages which are in seascape orientation (rotated 90
degrees clockwise), and the
.I \-f
option should be used for pages which have the width and height interchanged,
but are not rotated.
.PP
.I Psnup
normally uses `row-major' layout, where adjacent pages are placed in rows
across the paper.
The
.I \-c
option changes the order to `column-major', where successive pages are placed
in columns down the paper.
.PP
A margin to leave around the whole page can be specified with the
.I \-m
option. This is useful for sheets of `thumbnail' pages, because the normal
page margins are reduced by putting multiple pages on a single sheet.
.PP
The
.I \-b
option is used to specify an additional margin around each page on a sheet.
.PP
The
.I \-d
option draws a line around the border of each page, of the specified width.
If the \fIlwidth\fR parameter is omitted, a default linewidth of 1 point is
assumed. The linewidth is relative to the original page dimensions,
\fIi.e.\fR it is scaled down with the rest of the page.
.PP
The scale chosen by
.I psnup
can be overridden with the
.I \-s
option. This is useful to merge pages which are already reduced.
.PP
The
.I \-\fInup\fR
option selects the number of logical pages to put on each sheet of paper. This
can be any whole number;
.I psnup
tries to optimise the layout so that the minimum amount of space is wasted. If
.I psnup
cannot find a layout within its tolerance limit, it will abort with an error
message. The alternative form
.I \i \fInup\fR
can also be used, for compatibility with other n-up programs.
.PP
.I Psnup
normally prints the page numbers of the pages re-arranged; the
.I \-q
option suppresses this.
.SH EXAMPLES
The potential use of this utility is varied but one particular 
use is in conjunction with 
.I psbook(1).
For example, using groff to create a PostScript document and lpr as 
the 
.SM UNIX 
print spooler a typical command line might look like this: 
.sp
groff -Tps -ms \fIfile\fP | psbook | psnup -2 | lpr
.sp
Where file is a 4 page document this command will result in a 
two page document printing two pages of \fIfile\fP per page and
rearranges the page order to match the input pages 4 and 1 
on the first output page and
pages 2 then 3 of the input document 
on the second output page.
.SH AUTHOR
Angus Duggan
.SH "SEE ALSO"
@MAN@
.SH TRADEMARKS
.B PostScript
is a trademark of Adobe Systems Incorporated.
.SH BUGS
.I Psnup
does not accept all DSC comments.
