##
##  snmpdx -- SNMP Daemon Extension
##  Copyright (c) 2003 The OSSP Project <http://www.ossp.org/>
##  Copyright (c) 2003 Ralf S. Engelschall <rse@engelschall.com>
##  Copyright (c) 2003 Cable & Wireless <http://www.cw.com/>
##
##  Permission to use, copy, modify, and distribute this software for
##  any purpose with or without fee is hereby granted, provided that
##  the above copyright notice and this permission notice appear in all
##  copies.
##
##  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
##  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
##  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
##  IN NO EVENT SHALL THE AUTHORS AND COPYRIGHT HOLDERS AND THEIR
##  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
##  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
##  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
##  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
##  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
##  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
##  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
##  SUCH DAMAGE.
##
##  hwCpu: Hardware, CPU
##

package My::Probe::hwCpu;
our @ISA = qw(My::Probe);

sub oids ($) {
    my ($self) = @_;
    return $self->{-ctx}->{-mib}->oids("*.snmpdx.host.hardware.hwCpu.*");
}

sub probe ($$) {
    my ($self, $obj) = @_;

    if ($self->{-ctx}->{-platform}->id() =~ m/FreeBSD/i) {
        my $hwCpuNum       = undef;
        my $hwCpuInfoENTRY = undef; #N/A

        #   local workspace
        my $out; my $raw;

        #   query sysctl(8)
        $out = $self->{-ctx}->{-sys}->run("/sbin/sysctl -n hw.ncpu", "forever");
        $raw = $out->{-stdout};
        if ($raw =~ m/^\s*(.+?)\s*$/s) {
            $hwCpuNum = $1;
        }

        $obj->{-value} = $hwCpuNum if ($obj->{-name} =~ m/\.hwCpuNum$/);
    }
    elsif ($self->{-ctx}->{-platform}->id() =~ m/Linux/i) {
        my $hwCpuNum       = undef;
        my $hwCpuInfoENTRY = undef; #N/A

        #   local workspace
        my $out; my $raw;

        #   query dmesg(8)
        #   FIXME: this works only within a reasonable time after booting
        #          but I don't know any alternative method for querying the speed!
        $out = $self->{-ctx}->{-sys}->run("/bin/dmesg", "forever");
        $raw = $out->{-stdout};
        if ($raw =~ m/\nProcessors: (\d+)\n/si) {
            $hwCpuNum = $1;
        }

        $obj->{-value} = $hwCpuNum if ($obj->{-name} =~ m/\.hwCpuNum$/);
    }
    elsif($self->{-ctx}->{-platform}->id() =~ m/SunOS/i) {
        my $hwCpuNum       = undef;
        my $hwCpuInfoENTRY = undef;

        #   local workspace
        my $out; my $raw; my $arch;

        #   initialize arch
        $arch = $self->{-ctx}->{-platform}->arch();

        #   hwCpuSpeed
        $out = $self->{-ctx}->{-sys}->run("/usr/platform/$arch/sbin/prtdiag -v", "1m");
        $raw = $out->{-stdout};
        if ($raw =~ m/\n=+ CPUs =+\n.*?\n---[ -]+\n(.*?)\n=+/s) {
            $raw = $1;
            foreach $line (split "\n", $raw) {
                my ($brd,$cpu,$module,$mhz,$mb,$impl,$mask) = split(" ", $line);
                if ($cpu =~ m/^\d+$/) {
                    @hwCpuInfoENTRY[$cpu] = {} if (not defined @hwCpuInfoENTRY[$cpu]);
                    @hwCpuInfoENTRY[$cpu]->{hwCpuSpeed} = $mhz;
                }
            }
        }

        #   hwCpuTemp
        $out = $self->{-ctx}->{-sys}->run("/usr/platform/$arch/sbin/prtdiag -v", "1m");
        $raw = $out->{-stdout};
        if ($raw =~ m/\n=+ Environmental Status =+\n.*\nSystem Temperatures \(Celsius\):\n-+\n(.*?)\n=+/s) {
            $raw = $1;
            foreach $line (split "\n", $raw) {
                my ($cpu,$temp) = split(" ", $line);
                if ($cpu =~ m/CPU(\d+)/) {
                    $cpu = $1;
                    @hwCpuInfoENTRY[$cpu] = {} if (not defined @hwCpuInfoENTRY[$cpu]);
                    @hwCpuInfoENTRY[$cpu]->{hwCpuTemp} = $temp;
                }
            }
        }

        #   hwCpuNum
        $hwCpuNum = $#{@hwCpuInfoENTRY} + 1;
        
        $obj->{-value} = $hwCpuNum   if ($obj->{-name} =~ m/\.hwCpuNum$/);
        if ($obj->{-name} =~ m/\.hwCpuInfoENTRY\.([^.]+)\.(\d+)$/) {
            my $col = $1;
            my $row = ($2 > 0 ? $2 - 1 : 0);
            $self->{-ctx}->{-log}->printf(4, "col=%s row=%s", $col, $row);
            $obj->{-value} = @hwCpuInfoENTRY[$row]->{$col} if (defined @hwCpuInfoENTRY[$row] and defined @hwCpuInfoENTRY[$row]->{$col});
        }
    }
    return;
}

1;

